
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bill_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bill_hours")
    ringo_hours = model.addVar(vtype=gp.GRB.INTEGER, name="ringo_hours")
    mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")

    # Set objective function
    model.setObjective(
        5.86 * bill_hours**2
        + 3.14 * bill_hours * ringo_hours
        + 9.5 * ringo_hours * mary_hours
        + 9.69 * mary_hours**2
        + 6.42 * bill_hours
        + 9.76 * ringo_hours,
        gp.GRB.MAXIMIZE,
    )

    # Add constraints
    model.addConstr(9 * bill_hours**2 + 9 * mary_hours**2 >= 29)
    model.addConstr(9 * bill_hours**2 + 16 * ringo_hours**2 >= 21)
    model.addConstr(-8 * ringo_hours**2 + 4 * mary_hours**2 >= 0)
    model.addConstr(5 * bill_hours + 1 * mary_hours <= 97)
    model.addConstr(4 * ringo_hours + 1 * mary_hours <= 46)
    model.addConstr(5 * bill_hours + 4 * ringo_hours <= 44)
    model.addConstr(5 * bill_hours + 4 * ringo_hours + 1 * mary_hours <= 44)
    model.addConstr(9 * bill_hours + 9 * mary_hours <= 61)
    model.addConstr(16 * ringo_hours + 9 * mary_hours <= 37)
    model.addConstr(9 * bill_hours**2 + 16 * ringo_hours**2 <= 85)
    model.addConstr(9 * bill_hours + 16 * ringo_hours + 9 * mary_hours <= 85)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print("Optimal solution found:")
        print(f"Hours worked by Bill: {bill_hours.x}")
        print(f"Hours worked by Ringo: {ringo_hours.x}")
        print(f"Hours worked by Mary: {mary_hours.x}")
        print(f"Objective value: {model.objVal}")
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")
