
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # hours worked by Bill
    x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.INTEGER)  # hours worked by Mary

    # Define objective function
    model.setObjective(5.86*x0**2 + 3.14*x0*x1 + 9.5*x1*x2 + 9.69*x2**2 + 6.42*x0 + 9.76*x1, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(9*x0**2 + 9*x2**2 >= 29)
    model.addConstr(9*x0**2 + 16*x1**2 >= 21)
    model.addConstr(-8*x1**2 + 4*x2**2 >= 0)
    model.addConstr(5*x0 + 1*x2 <= 97)
    model.addConstr(4*x1 + 1*x2 <= 46)
    model.addConstr(5*x0 + 4*x1 <= 44)
    model.addConstr(5*x0 + 4*x1 + 1*x2 <= 44)
    model.addConstr(9*x0 + 9*x2 <= 61)
    model.addConstr(16*x1 + 9*x2 <= 37)
    model.addConstr(9*x0**2 + 16*x1**2 <= 85)
    model.addConstr(9*x0 + 16*x1 + 9*x2 <= 85)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
