
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter sandwiches")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ravioli")


# Set objective function
m.setObjective(6*x0 + 7*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x0 + 32*x1 + 12*x2 <= 198, "c0")
m.addConstr(18*x0 + 23*x1 + 18*x2 <= 304, "c1")
m.addConstr(18*x0 + 23*x1 + 18*x2 >= 84, "c2")
m.addConstr(20*x0 + 12*x2 <= 172, "c3")
m.addConstr(32*x1 + 12*x2 <= 182, "c4")
m.addConstr(20*x0 + 32*x1 + 12*x2 <= 182, "c5")
m.addConstr(18*x0 + 23*x1 <= 229, "c6")
m.addConstr(23*x1 + 18*x2 <= 164, "c7")
m.addConstr(18*x0 + 23*x1 + 18*x2 <= 164, "c8")



# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

