
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='peanutbutter_sandwiches', lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name='tomatoes', lb=0)  # No lower bound specified, assuming 0
    x3 = model.addVar(name='ravioli', lb=0)  # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(6 * x1 + 7 * x2 + 5 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(18 * x1 + 23 * x2 + 18 * x3 >= 84)  # Minimum umami index
    model.addConstr(20 * x1 + 12 * x3 <= 172)  # Carbohydrates from peanutbutter sandwiches and ravioli
    model.addConstr(32 * x2 + 12 * x3 <= 182)  # Carbohydrates from tomatoes and ravioli
    model.addConstr(20 * x1 + 32 * x2 + 12 * x3 <= 182)  # Total carbohydrates
    model.addConstr(18 * x1 + 23 * x2 <= 229)  # Umami index from peanutbutter sandwiches and tomatoes
    model.addConstr(23 * x2 + 18 * x3 <= 164)  # Umami index from tomatoes and ravioli
    model.addConstr(18 * x1 + 23 * x2 + 18 * x3 <= 164)  # Total umami index maximum

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Peanutbutter sandwiches: {x1.varValue}")
        print(f"Tomatoes: {x2.varValue}")
        print(f"Ravioli: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
