
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
    vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")


    # Set objective function
    m.setObjective(8*vitamin_e + 2*vitamin_b12 + vitamin_a, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(31*vitamin_e + 28*vitamin_a >= 26, "c1")
    m.addConstr(14*vitamin_b12 + 28*vitamin_a >= 41, "c2")
    m.addConstr(31*vitamin_e + 14*vitamin_b12 + 28*vitamin_a >= 41, "c3")
    m.addConstr(4*vitamin_e - 3*vitamin_a >= 0, "c4")
    m.addConstr(8*vitamin_b12 - 2*vitamin_a >= 0, "c5")
    m.addConstr(31*vitamin_e + 14*vitamin_b12 + 28*vitamin_a <= 151, "c6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_e:', vitamin_e.x)
        print('vitamin_b12:', vitamin_b12.x)
        print('vitamin_a:', vitamin_a.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
