
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_E")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B12")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_A")

# Set the objective function
m.setObjective(8*x1 + 2*x2 + x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(31*x1 + 28*x3 >= 26, "muscle_growth_index_E_and_A")
m.addConstr(14*x2 + 28*x3 >= 41, "muscle_growth_index_B12_and_A")
m.addConstr(31*x1 + 14*x2 + 28*x3 >= 41, "total_muscle_growth_index")
m.addConstr(4*x1 - 3*x3 >= 0, "vitamin_E_and_A_ratio")
m.addConstr(8*x2 - 2*x3 >= 0, "vitamin_B12_and_A_ratio")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Milligrams of Vitamin E:", x1.x)
    print("Milligrams of Vitamin B12:", x2.x)
    print("Milligrams of Vitamin A:", x3.x)
else:
    print("No optimal solution found.")
