
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams_of_vitamin_E", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name="milligrams_of_vitamin_B12", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = model.addVar(name="milligrams_of_vitamin_A", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Set the objective function
model.setObjective(8*x1 + 2*x2 + x3, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(31*x1 + 28*x3 >= 26, name="constraint_1")
model.addConstr(14*x2 + 28*x3 >= 41, name="constraint_2")
model.addConstr(31*x1 + 14*x2 + 28*x3 >= 41, name="constraint_3")
model.addConstr(4*x1 - 3*x3 >= 0, name="constraint_4")
model.addConstr(8*x2 - 2*x3 >= 0, name="constraint_5")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Milligrams of vitamin E: ", x1.varValue)
    print("Milligrams of vitamin B12: ", x2.varValue)
    print("Milligrams of vitamin A: ", x3.varValue)
else:
    print("The model is infeasible")
