
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    dale_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
    george_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george_hours")


    # Set objective function
    model.setObjective(6 * dale_hours + 2 * george_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2 * dale_hours + 6 * george_hours >= 6, "paperwork_min")
    model.addConstr(4 * dale_hours + 9 * george_hours >= 16, "computer_min")
    model.addConstr(-10 * dale_hours + 6 * george_hours >= 0, "dale_george_ratio")
    model.addConstr(2 * dale_hours + 6 * george_hours <= 19, "paperwork_max")
    model.addConstr(4 * dale_hours + 9 * george_hours <= 28, "computer_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Dale: {dale_hours.x}")
        print(f"Hours worked by George: {george_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print("Encountered an attribute error")

