
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_George")

# Set the objective function
m.setObjective(6*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 6*x2 >= 6, "paperwork_rating_min")
m.addConstr(4*x1 + 9*x2 >= 16, "computer_rating_min")
m.addConstr(-10*x1 + 6*x2 >= 0, "mixed_constraint")
m.addConstr(2*x1 + 6*x2 <= 19, "paperwork_rating_max")
m.addConstr(4*x1 + 9*x2 <= 28, "computer_rating_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Dale: {x1.x}")
    print(f"Hours worked by George: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
