
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="hours_worked_by_Dale", lb=0)  # hours worked by Dale
x2 = model.addVar(name="hours_worked_by_George", lb=0)  # hours worked by George

# Define the objective function
model.setObjective(6 * x1 + 2 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(2 * x1 + 6 * x2 >= 6, name="paperwork_rating")
model.addConstr(4 * x1 + 9 * x2 >= 16, name="computer_rating")
model.addConstr(-10 * x1 + 6 * x2 >= 0, name="hourly_constraint")
model.addConstr(2 * x1 + 6 * x2 <= 27, name="paperwork_upper_bound")
model.addConstr(4 * x1 + 9 * x2 <= 33, name="computer_upper_bound")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x1.varValue}")
    print(f"Hours worked by George: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
