
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    protein = m.addVar(vtype=gp.GRB.INTEGER, name="protein")
    carbs = m.addVar(vtype=gp.GRB.INTEGER, name="carbs")
    vitamin_b7 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")

    # Set objective function
    m.setObjective(4.15 * protein + 9.51 * carbs + 9.5 * vitamin_b7, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(30 * carbs + 32 * vitamin_b7 >= 121, "kidney_support_carbs_b7")
    m.addConstr(32 * protein + 32 * vitamin_b7 >= 135, "kidney_support_protein_b7")
    m.addConstr(32 * protein + 30 * carbs >= 72, "kidney_support_protein_carbs")
    m.addConstr(15 * protein + 30 * carbs >= 28, "cognitive_protein_carbs")
    m.addConstr(32 * protein + 32 * vitamin_b7 <= 450, "kidney_support_protein_b7_upper")
    m.addConstr(32 * protein + 30 * carbs + 32 * vitamin_b7 <= 309, "kidney_support_total")
    m.addConstr(30 * carbs + 1 * vitamin_b7 <= 112, "cognitive_carbs_b7")
    m.addConstr(15 * protein + 1 * vitamin_b7 <= 116, "cognitive_protein_b7")
    m.addConstr(15 * protein + 30 * carbs <= 142, "cognitive_protein_carbs_upper")
    m.addConstr(15 * protein + 30 * carbs + 1 * vitamin_b7 <= 142, "cognitive_total")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Protein: %g' % protein.x)
        print('Carbs: %g' % carbs.x)
        print('Vitamin B7: %g' % vitamin_b7.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
