
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
ravioli = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ravioli")
pizza = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pizza")
apple_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apple_pies")


# Set objective function
m.setObjective(1 * ravioli + 9 * pizza + 1 * apple_pies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * ravioli + 1 * apple_pies >= 42, "c1")
m.addConstr(6 * pizza + 1 * apple_pies >= 18, "c2")
m.addConstr(5 * ravioli + 6 * pizza + 1 * apple_pies >= 39, "c3")
m.addConstr(11 * ravioli + 8 * pizza <= 38, "c4")
m.addConstr(11 * ravioli + 9 * apple_pies <= 84, "c5")
m.addConstr(11 * ravioli + 8 * pizza + 9 * apple_pies <= 84, "c6")
m.addConstr(6 * pizza + 1 * apple_pies <= 114, "c7")
m.addConstr(5 * ravioli + 1 * apple_pies <= 153, "c8")
m.addConstr(5 * ravioli + 6 * pizza + 1 * apple_pies <= 153, "c9")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ravioli:', ravioli.x)
    print('pizza:', pizza.x)
    print('apple_pies:', apple_pies.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

