
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="ravioli", lb=0)  # ravioli
x1 = m.addVar(name="slices of pizza", lb=0)  # slices of pizza
x2 = m.addVar(name="apple pies", lb=0)  # apple pies

# Define the objective function
m.setObjective(x0 + 9 * x1 + x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(5 * x0 + x2 >= 42, name="umami_ravioli_apple_pies")
m.addConstr(6 * x1 + x2 >= 18, name="umami_pizza_apple_pies")
m.addConstr(5 * x0 + 6 * x1 + x2 >= 39, name="umami_total")
m.addConstr(11 * x0 + 8 * x1 <= 38, name="healthiness_ravioli_pizza")
m.addConstr(11 * x0 + 9 * x2 <= 84, name="healthiness_ravioli_apple_pies")
m.addConstr(11 * x0 + 8 * x1 + 9 * x2 <= 84, name="healthiness_total")
m.addConstr(6 * x1 + x2 <= 114, name="umami_pizza_apple_pies_upper")
m.addConstr(5 * x0 + x2 <= 153, name="umami_ravioli_apple_pies_upper")
m.addConstr(5 * x0 + 6 * x1 + x2 <= 153, name="umami_total_upper")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ravioli: ", x0.varValue)
    print("Slices of pizza: ", x1.varValue)
    print("Apple pies: ", x2.varValue)
else:
    print("The model is infeasible")
