
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
    paper_towel_rolls = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towel_rolls")
    candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")
    toilet_paper_rolls = m.addVar(vtype=gp.GRB.INTEGER, name="toilet_paper_rolls")
    rubber_gloves = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")

    # Set objective function
    m.setObjective(5*lightbulbs + 7*paper_towel_rolls + 3*candles + 6*toilet_paper_rolls + 8*rubber_gloves, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(3*lightbulbs + 14*paper_towel_rolls + 25*candles + 14*toilet_paper_rolls + 12*rubber_gloves <= 244, "dollar_value")
    m.addConstr(3*lightbulbs + 14*toilet_paper_rolls >= 20, "c1")
    m.addConstr(14*paper_towel_rolls + 25*candles >= 38, "c2")
    m.addConstr(3*lightbulbs + 25*candles >= 33, "c3")
    m.addConstr(3*lightbulbs + 14*paper_towel_rolls >= 42, "c4")
    m.addConstr(14*toilet_paper_rolls + 12*rubber_gloves >= 41, "c5")
    m.addConstr(14*paper_towel_rolls + 12*rubber_gloves >= 39, "c6")
    m.addConstr(3*lightbulbs + 12*rubber_gloves >= 30, "c7")
    m.addConstr(3*lightbulbs + 14*paper_towel_rolls + 25*candles + 14*toilet_paper_rolls + 12*rubber_gloves >= 30, "c8")
    m.addConstr(14*paper_towel_rolls + 12*rubber_gloves <= 50, "c9")
    m.addConstr(3*lightbulbs + 14*paper_towel_rolls <= 229, "c10")
    m.addConstr(25*candles + 12*rubber_gloves <= 58, "c11")
    m.addConstr(14*toilet_paper_rolls + 12*rubber_gloves <= 244, "c12")
    m.addConstr(14*paper_towel_rolls + 14*toilet_paper_rolls <= 114, "c13")
    m.addConstr(3*lightbulbs + 25*candles + 12*rubber_gloves <= 244, "c14")
    m.addConstr(14*paper_towel_rolls + 25*candles + 14*toilet_paper_rolls <= 109, "c15")
    m.addConstr(3*lightbulbs + 14*toilet_paper_rolls + 12*rubber_gloves <= 196, "c16")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
