
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='lightbulbs', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='paper towel rolls', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='candles', vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name='toilet paper rolls', vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name='rubber gloves', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(5*x1 + 7*x2 + 3*x3 + 6*x4 + 8*x5, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3*x1 + 14*x2 + 25*x3 + 14*x4 + 12*x5 >= 30)
    model.addConstr(3*x1 + 14*x4 >= 20)
    model.addConstr(14*x2 + 25*x3 >= 38)
    model.addConstr(3*x1 + 25*x3 >= 33)
    model.addConstr(3*x1 + 14*x2 >= 42)
    model.addConstr(14*x4 + 12*x5 >= 41)
    model.addConstr(14*x2 + 12*x5 >= 39)
    model.addConstr(3*x1 + 12*x5 >= 30)
    model.addConstr(14*x2 + 12*x5 <= 50)
    model.addConstr(3*x1 + 14*x2 <= 229)
    model.addConstr(25*x3 + 12*x5 <= 58)
    model.addConstr(14*x4 + 12*x5 <= 244)
    model.addConstr(14*x2 + 14*x4 <= 114)
    model.addConstr(3*x1 + 25*x3 + 12*x5 <= 244)
    model.addConstr(14*x2 + 25*x3 + 14*x4 <= 109)
    model.addConstr(3*x1 + 14*x4 + 12*x5 <= 196)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Lightbulbs: ', x1.varValue)
        print('Paper towel rolls: ', x2.varValue)
        print('Candles: ', x3.varValue)
        print('Toilet paper rolls: ', x4.varValue)
        print('Rubber gloves: ', x5.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
