
import gurobipy as gp

# Create a new model
model = gp.Model("Optimize Hours")

# Create variables
mary = model.addVar(vtype=gp.GRB.INTEGER, name="mary")
paul = model.addVar(vtype=gp.GRB.INTEGER, name="paul")
jean = model.addVar(vtype=gp.GRB.INTEGER, name="jean")
ringo = model.addVar(vtype=gp.GRB.INTEGER, name="ringo")
hank = model.addVar(vtype=gp.GRB.INTEGER, name="hank")


# Set objective function
model.setObjective(5*mary + 5*paul + 2*jean + 9*ringo + 5*hank, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12*ringo + 2*hank >= 78)
model.addConstr(13*mary + 15*paul >= 45)
model.addConstr(15*paul + 12*ringo >= 49)
model.addConstr(13*mary + 2*hank >= 48)
model.addConstr(15*paul + 20*jean >= 34)
model.addConstr(20*jean + 12*ringo >= 40)
model.addConstr(13*mary + 20*jean >= 59)
model.addConstr(13*mary + 15*paul + 2*hank >= 80)
model.addConstr(15*paul + 20*jean + 2*hank >= 80)
model.addConstr(13*mary + 15*paul + 2*hank >= 52)
model.addConstr(15*paul + 20*jean + 2*hank >= 52)
model.addConstr(4*paul + 6*jean >= 56)
model.addConstr(12*ringo + 18*hank >= 68)
model.addConstr(23*mary + 6*jean + 12*ringo >= 52)
model.addConstr(13*mary + 20*jean <= 120)
model.addConstr(12*ringo + 2*hank <= 161)
model.addConstr(13*mary + 15*paul <= 247)
model.addConstr(13*mary + 15*paul + 20*jean + 12*ringo + 2*hank <= 247)
model.addConstr(6*jean + 12*ringo <= 205)
model.addConstr(23*mary + 18*hank <= 294)
model.addConstr(4*paul + 6*jean <= 320)
model.addConstr(4*paul + 12*ringo + 18*hank <= 330)
model.addConstr(23*mary + 6*jean + 12*ringo <= 175)
model.addConstr(4*paul + 6*jean + 18*hank <= 309)
model.addConstr(23*mary + 6*jean + 18*hank <= 293)
model.addConstr(23*mary + 4*paul + 6*jean + 12*ringo + 18*hank <= 293)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

