
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER)  # hours worked by Mary
    x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER)  # hours worked by Paul
    x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER)  # hours worked by Jean
    x3 = model.addVar(name='x3', vtype=gurobi.GRB.INTEGER)  # hours worked by Ringo
    x4 = model.addVar(name='x4', vtype=gurobi.GRB.INTEGER)  # hours worked by Hank

    # Objective function
    model.setObjective(5 * x0 + 5 * x1 + 2 * x2 + 9 * x3 + 5 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13 * x0 <= 405)
    model.addConstr(23 * x0 <= 454)
    model.addConstr(15 * x1 <= 405)
    model.addConstr(4 * x1 <= 454)
    model.addConstr(20 * x2 <= 405)
    model.addConstr(6 * x2 <= 454)
    model.addConstr(12 * x3 <= 405)
    model.addConstr(12 * x3 <= 454)
    model.addConstr(2 * x4 <= 405)
    model.addConstr(18 * x4 <= 454)
    model.addConstr(12 * x3 + 2 * x4 >= 78)
    model.addConstr(13 * x0 + 15 * x1 >= 45)
    model.addConstr(15 * x1 + 12 * x3 >= 49)
    model.addConstr(13 * x0 + 2 * x4 >= 48)
    model.addConstr(15 * x1 + 20 * x2 >= 34)
    model.addConstr(20 * x2 + 12 * x3 >= 40)
    model.addConstr(13 * x0 + 20 * x2 >= 59)
    model.addConstr(13 * x0 + 15 * x1 + 2 * x4 >= 80)
    model.addConstr(15 * x1 + 20 * x2 + 2 * x4 >= 80)
    model.addConstr(13 * x0 + 15 * x1 + 2 * x4 >= 52)
    model.addConstr(15 * x1 + 20 * x2 + 2 * x4 >= 52)
    model.addConstr(4 * x1 + 6 * x2 >= 56)
    model.addConstr(12 * x3 + 18 * x4 >= 68)
    model.addConstr(23 * x0 + 6 * x2 + 12 * x3 >= 52)
    model.addConstr(13 * x0 + 20 * x2 <= 120)
    model.addConstr(12 * x3 + 2 * x4 <= 161)
    model.addConstr(13 * x0 + 15 * x1 <= 247)
    model.addConstr(13 * x0 + 15 * x1 + 20 * x2 + 12 * x3 + 2 * x4 <= 247)
    model.addConstr(6 * x2 + 12 * x3 <= 205)
    model.addConstr(23 * x0 + 18 * x4 <= 294)
    model.addConstr(4 * x1 + 6 * x2 <= 320)
    model.addConstr(4 * x1 + 12 * x3 + 18 * x4 <= 330)
    model.addConstr(23 * x0 + 6 * x2 + 12 * x3 <= 175)
    model.addConstr(4 * x1 + 6 * x2 + 18 * x4 <= 309)
    model.addConstr(23 * x0 + 6 * x2 + 18 * x4 <= 293)
    model.addConstr(23 * x0 + 4 * x1 + 6 * x2 + 12 * x3 + 18 * x4 <= 293)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Mary: ", x0.varValue)
        print("Hours worked by Paul: ", x1.varValue)
        print("Hours worked by Jean: ", x2.varValue)
        print("Hours worked by Ringo: ", x3.varValue)
        print("Hours worked by Hank: ", x4.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
