
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
kiwis = m.addVar(lb=0, name="kiwis")
pizza = m.addVar(lb=0, name="slices_of_pizza")
tomatoes = m.addVar(lb=0, name="tomatoes")
chicken = m.addVar(lb=0, name="chicken_breasts")
hamburgers = m.addVar(lb=0, name="hamburgers")


# Set objective function
m.setObjective(3*kiwis**2 + 4*kiwis*pizza + 6*kiwis*tomatoes + 1*kiwis*chicken + 6*kiwis*hamburgers + 7*pizza**2 + 6*pizza*tomatoes + 6*pizza*chicken + 5*tomatoes**2 + 3*tomatoes*chicken + 9*tomatoes*hamburgers + 2*chicken**2 + 5*chicken*hamburgers + 1*hamburgers**2 + 1*kiwis + 9*pizza + 3*tomatoes + 2*chicken + 4*hamburgers, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*kiwis + 3*pizza + 10*tomatoes + 10*chicken + 6*hamburgers <= 275, "c0")
m.addConstr(1*kiwis + 14*pizza + 8*tomatoes + 5*chicken + 8*hamburgers <= 394, "c1")
m.addConstr(6*kiwis + 8*pizza + 11*tomatoes + 14*chicken + 7*hamburgers <= 395, "c2")
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

