
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Work_Optimization")

    # Create variables
    bobby_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")
    ringo_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo_hours")
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")


    # Set objective function
    model.setObjective(8.75 * bobby_hours + 1.86 * ringo_hours + 7.17 * laura_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(16 * bobby_hours + 13 * ringo_hours + 22 * laura_hours <= 148, "c0")
    model.addConstr(21 * bobby_hours + 18 * ringo_hours + 8 * laura_hours <= 241, "c1")
    model.addConstr(16 * bobby_hours + 22 * laura_hours >= 36, "c2")
    model.addConstr(16 * bobby_hours + 13 * ringo_hours >= 46, "c3")
    model.addConstr(21 * bobby_hours + 8 * laura_hours >= 50, "c4")
    model.addConstr(18 * ringo_hours + 8 * laura_hours >= 70, "c5")
    model.addConstr(16 * bobby_hours + 13 * ringo_hours <= 70, "c6")
    model.addConstr(13 * ringo_hours + 22 * laura_hours <= 144, "c7")
    model.addConstr(16 * bobby_hours + 13 * ringo_hours + 22 * laura_hours <= 76, "c8")
    model.addConstr(21 * bobby_hours + 8 * laura_hours <= 182, "c9")
    model.addConstr(21 * bobby_hours + 18 * ringo_hours + 8 * laura_hours <= 182, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Bobby Hours: %g' % bobby_hours.x)
        print('Ringo Hours: %g' % ringo_hours.x)
        print('Laura Hours: %g' % laura_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
