
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Bobby", lb=0)
    x1 = model.addVar(name="hours_worked_by_Ringo", lb=0)
    x2 = model.addVar(name="hours_worked_by_Laura", lb=0)

    # Objective function
    model.setObjective(8.75 * x0 + 1.86 * x1 + 7.17 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(16 * x0 <= 148)
    model.addConstr(13 * x1 <= 148)
    model.addConstr(22 * x2 <= 148)
    model.addConstr(21 * x0 <= 241)
    model.addConstr(18 * x1 <= 241)
    model.addConstr(8 * x2 <= 241)

    model.addConstr(16 * x0 + 22 * x2 >= 36)
    model.addConstr(16 * x0 + 13 * x1 >= 46)
    model.addConstr(21 * x0 + 8 * x2 >= 50)
    model.addConstr(18 * x1 + 8 * x2 >= 70)

    model.addConstr(16 * x0 + 13 * x1 <= 70)
    model.addConstr(13 * x1 + 22 * x2 <= 144)
    model.addConstr(16 * x0 + 13 * x1 + 22 * x2 <= 76)

    model.addConstr(21 * x0 + 18 * x1 + 8 * x2 <= 182)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Bobby: ", x0.varValue)
        print("Hours worked by Ringo: ", x1.varValue)
        print("Hours worked by Laura: ", x2.varValue)
    else:
        print("No optimal solution found")

optimize_problem()
