
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_iron_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B7")  # milligrams of vitamin B7
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="iron")  # milligrams of iron

    # Set objective function
    m.setObjective(1.94 * x0 + 6.5 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(13 * x0 + 11 * x1 >= 37, "kidney_support_min")
    m.addConstr(-10 * x0 + 2 * x1 >= 0, "ratio_constraint")
    m.addConstr(13 * x0 + 11 * x1 <= 95, "kidney_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Milligrams of Vitamin B7: {x0.x}")
        print(f"  Milligrams of Iron: {x1.x}")
        print(f"  Objective value: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
