
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B7")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_iron")

# Set the objective function
m.setObjective(1.94*x1 + 6.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*x1 + 11*x2 >= 37, name="kidney_support_index_lower_bound")
m.addConstr(-10*x1 + 2*x2 >= 0, name="linear_inequality_constraint")
m.addConstr(13*x1 + 11*x2 <= 95, name="kidney_support_index_upper_bound")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B7: {x1.x}")
    print(f"Milligrams of Iron: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
