
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='milligrams of vitamin B7', lb=0, ub=None, integrality=0)
x2 = model.addVar(name='milligrams of iron', lb=0, ub=None, integrality=1)

# Set the objective function
model.setObjective(1.94 * x1 + 6.5 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(13 * x1 <= 114, name='kidney_support_index_vitamin_B7')
model.addConstr(11 * x2 <= 114, name='kidney_support_index_iron')
model.addConstr(13 * x1 + 11 * x2 >= 37, name='combined_kidney_support_index_min')
model.addConstr(-10 * x1 + 2 * x2 >= 0, name='linear_constraint')
model.addConstr(13 * x1 + 11 * x2 <= 95, name='combined_kidney_support_index_max')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Optimal solution found.')
    print(f'Milligrams of vitamin B7: {x1.varValue}')
    print(f'Milligrams of iron: {x2.varValue}')
    print(f'Objective function value: {model.objVal}')
else:
    print('No optimal solution found.')
