
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B2
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of magnesium
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of zinc


    # Set objective function
    model.setObjective(6.31 * x0 + 9.68 * x1 + 1.01 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x0 + 1 * x1 + 24 * x2 >= 23, "c0")
    model.addConstr(3 * x0 + 1 * x1 >= 34, "c1")
    model.addConstr(1 * x1 + 24 * x2 >= 23, "c2")
    model.addConstr(2 * x0 + 19 * x1 <= 306, "c3")
    model.addConstr(2 * x0 + 6 * x2 <= 213, "c4")
    model.addConstr(2 * x0 + 19 * x1 + 6 * x2 <= 213, "c5")
    model.addConstr(3 * x0 + 24 * x2 <= 154, "c6")
    model.addConstr(1 * x1 + 24 * x2 <= 139, "c7")
    model.addConstr(3 * x0 + 1 * x1 + 24 * x2 <= 65, "c8")
    model.addConstr(3 * x0 + 1 * x1 + 24 * x2 <= 65, "c9")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
