
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B2
    x2 = model.addVar(name="x2", lb=0)  # milligrams of magnesium
    x3 = model.addVar(name="x3", lb=0)  # milligrams of zinc

    # Define the objective function
    model.setObjective(6.31 * x1 + 9.68 * x2 + 1.01 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + x2 + 24 * x3 >= 23)  
    model.addConstr(3 * x1 + x2 >= 34)  
    model.addConstr(x2 + 24 * x3 >= 23)  
    model.addConstr(2 * x1 + 19 * x2 <= 306)  
    model.addConstr(2 * x1 + 6 * x3 <= 213)  
    model.addConstr(2 * x1 + 19 * x2 + 6 * x3 <= 213)  
    model.addConstr(3 * x1 + 24 * x3 <= 154)  
    model.addConstr(x2 + 24 * x3 <= 139)  
    model.addConstr(3 * x1 + x2 + 24 * x3 <= 65)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B2: {x1.varValue}")
        print(f"Milligrams of magnesium: {x2.varValue}")
        print(f"Milligrams of zinc: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
