
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("salad_optimization")

# Create variables
fruit_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
bagged_salads = m.addVar(lb=0, vtype=GRB.INTEGER, name="bagged_salads")


# Set objective function
m.setObjective(4 * fruit_salads + 4 * bagged_salads, GRB.MINIMIZE)

# Add constraints
m.addConstr(28 * fruit_salads + 11 * bagged_salads >= 30, "total_cost_min")
m.addConstr(28 * fruit_salads >= 30, "fruit_cost_min")
m.addConstr(11 * bagged_salads >= 30, "bagged_cost_min")
m.addConstr(9 * fruit_salads + 29 * bagged_salads >= 47, "sourness_min")
m.addConstr(8 * fruit_salads - 2 * bagged_salads >= 0, "fruit_bagged_ratio")
m.addConstr(28 * fruit_salads + 11 * bagged_salads <= 47, "total_cost_max")
m.addConstr(9 * fruit_salads + 29 * bagged_salads <= 123, "sourness_max")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('fruit_salads:', fruit_salads.x)
    print('bagged_salads:', bagged_salads.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

