
from gurobipy import *

# Create a model
m = Model("Salad_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="fruit_salads")
x2 = m.addVar(vtype=GRB.INTEGER, name="bagged_salads")

# Set objective function
m.setObjective(4*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(28*x1 + 11*x2 >= 30, name="total_cost_min")
m.addConstr(9*x1 + 29*x2 >= 47, name="sourness_index_min")
m.addConstr(8*x1 - 2*x2 >= 0, name="additional_linear_constraint")
m.addConstr(28*x1 + 11*x2 <= 89, name="total_cost_max")
m.addConstr(9*x1 + 29*x2 <= 123, name="sourness_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"fruit_salads: {x1.x}")
    print(f"bagged_salads: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
