
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="fruit_salads", lb=0)  # Assuming no lower bound for x1
    x2 = model.addVar(name="bagged_salads", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 4*x1 + 4*x2
    model.setObjective(4*x1 + 4*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(28*x1 + 11*x2 >= 30, name="total_cost_min")
    model.addConstr(9*x1 + 29*x2 >= 47, name="total_sourness_min")
    model.addConstr(8*x1 - 2*x2 >= 0, name="sourness_balance")
    model.addConstr(28*x1 + 11*x2 <= 89, name="total_cost_max")
    model.addConstr(9*x1 + 29*x2 <= 123, name="total_sourness_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Fruit Salads: {x1.varValue}")
        print(f"Bagged Salads: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
