
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    tomatoes = m.addVar(vtype=gp.GRB.INTEGER, name="tomatoes")
    corn_cobs = m.addVar(vtype=gp.GRB.INTEGER, name="corn_cobs")
    ramen = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ramen")


    # Set objective function
    m.setObjective(9.48 * tomatoes + 4.93 * corn_cobs + 1.09 * ramen, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(19 * tomatoes + 12 * corn_cobs >= 60, "protein_constraint1")
    m.addConstr(17 * corn_cobs + 13 * ramen <= 100, "calcium_constraint1")
    m.addConstr(11 * tomatoes + 17 * corn_cobs <= 132, "calcium_constraint2")
    m.addConstr(11 * tomatoes + 13 * ramen <= 77, "calcium_constraint3")
    m.addConstr(11 * tomatoes + 17 * corn_cobs + 13 * ramen <= 77, "calcium_constraint4")
    m.addConstr(12 * corn_cobs + 9 * ramen <= 181, "protein_constraint2")
    m.addConstr(19 * tomatoes + 9 * ramen <= 143, "protein_constraint3")
    m.addConstr(19 * tomatoes + 12 * corn_cobs <= 183, "protein_constraint4")
    m.addConstr(19 * tomatoes + 12 * corn_cobs + 9 * ramen <= 183, "protein_constraint5")

    # Resource Constraints from the problem description
    m.addConstr(11 * tomatoes + 17 * corn_cobs + 13 * ramen <= 133, "calcium_resource_constraint")
    m.addConstr(19 * tomatoes + 12 * corn_cobs + 9 * ramen <= 205, "protein_resource_constraint")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('tomatoes:', tomatoes.x)
        print('corn_cobs:', corn_cobs.x)
        print('ramen:', ramen.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
