
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
tomatoes = model.addVar(name="tomatoes", lb=0, ub=gurobi.GRB.INFINITY, integrality=1)
corn_cobs = model.addVar(name="corn cobs", lb=0, ub=gurobi.GRB.INFINITY, integrality=1)
bowls_of_instant_ramen = model.addVar(name="bowls_of_instant_ramen", lb=0, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(9.48 * tomatoes + 4.93 * corn_cobs + 1.09 * bowls_of_instant_ramen, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(19 * tomatoes + 12 * corn_cobs >= 60)
model.addConstr(17 * corn_cobs + 13 * bowls_of_instant_ramen <= 100)
model.addConstr(11 * tomatoes + 17 * corn_cobs <= 132)
model.addConstr(11 * tomatoes + 13 * bowls_of_instant_ramen <= 77)
model.addConstr(11 * tomatoes + 17 * corn_cobs + 13 * bowls_of_instant_ramen <= 77)
model.addConstr(12 * corn_cobs + 9 * bowls_of_instant_ramen <= 181)
model.addConstr(19 * tomatoes + 9 * bowls_of_instant_ramen <= 143)
model.addConstr(19 * tomatoes + 12 * corn_cobs <= 183)
model.addConstr(19 * tomatoes + 12 * corn_cobs + 9 * bowls_of_instant_ramen <= 183)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Tomatoes: ", tomatoes.varValue)
    print("Corn Cobs: ", corn_cobs.varValue)
    print("Bowls of Instant Ramen: ", bowls_of_instant_ramen.varValue)
else:
    print("The model is infeasible")
