
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="blue_highlighters")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="usb_flash_drives")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="hole_punches")

    # Set objective function
    model.setObjective(5.14 * x0 + 7.99 * x1 + 3.29 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12 * x0 + 11 * x1 >= 22, "c0")
    model.addConstr(11 * x1 + 3 * x2 >= 29, "c1")
    model.addConstr(12 * x0 + 11 * x1 + 3 * x2 >= 29, "c2")
    model.addConstr(4 * x1 + 6 * x2 >= 45, "c3")
    model.addConstr(12 * x0 + 4 * x1 >= 50, "c4")
    model.addConstr(12 * x0 + 4 * x1 + 6 * x2 >= 50, "c5")
    model.addConstr(11 * x1 + 3 * x2 >= 24, "c6")
    model.addConstr(5 * x0 + 11 * x1 >= 24, "c7")
    model.addConstr(5 * x0 + 11 * x1 + 3 * x2 >= 34, "c8")
    model.addConstr(18 * x0 + 8 * x2 >= 46, "c9")
    model.addConstr(13 * x1 + 8 * x2 >= 47, "c10")
    model.addConstr(18 * x0 + 13 * x1 + 8 * x2 >= 47, "c11")
    model.addConstr(-3 * x0 + 2 * x1 >= 0, "c12")
    model.addConstr(12 * x0 + 4 * x1 <= 116, "c13")
    model.addConstr(12 * x0 + 4 * x1 + 6 * x2 <= 82, "c14")
    model.addConstr(5 * x0 + 11 * x1 + 3 * x2 <= 49, "c15")
    model.addConstr(18 * x0 + 13 * x1 <= 128, "c16")
    model.addConstr(18 * x0 + 8 * x2 <= 139, "c17")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
