
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="blue_highlighters", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="usb_flash_drives", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="hole_punches", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(5.14*x0 + 7.99*x1 + 3.29*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(12*x0 + 11*x1 >= 22)
m.addConstr(11*x1 + 3*x2 >= 29)
m.addConstr(12*x0 + 11*x1 + 3*x2 >= 29)
m.addConstr(4*x1 + 6*x2 >= 45)
m.addConstr(12*x0 + 4*x1 >= 50)
m.addConstr(12*x0 + 4*x1 + 6*x2 >= 50)
m.addConstr(11*x1 + 3*x2 >= 24)
m.addConstr(5*x0 + 11*x1 >= 24)
m.addConstr(5*x0 + 11*x1 + 3*x2 >= 34)
m.addConstr(18*x0 + 8*x2 >= 46)
m.addConstr(13*x1 + 8*x2 >= 47)
m.addConstr(18*x0 + 13*x1 + 8*x2 >= 47)
m.addConstr(-3*x0 + 2*x1 >= 0)
m.addConstr(12*x0 + 4*x1 <= 116)
m.addConstr(12*x0 + 4*x1 + 6*x2 <= 82)
m.addConstr(5*x0 + 11*x1 + 3*x2 <= 49)
m.addConstr(18*x0 + 13*x1 <= 128)
m.addConstr(18*x0 + 8*x2 <= 139)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Blue highlighters: ", x0.varValue)
    print("USB flash drives: ", x1.varValue)
    print("Hole punches: ", x2.varValue)
else:
    print("The model is infeasible")
