
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


# Set objective function
m.setObjective(8*x0**2 + 3*x0*x2 + 8*x1*x2 + 3*x1*x3 + 6*x2**2 + 2*x1, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.53*x0 + 0.99*x1 + 1.79*x2 + 1.35*x3 <= 224)
m.addConstr(1.25*x0 + 2.94*x1 + 0.12*x2 + 3.33*x3 <= 220)
m.addConstr(1.96*x0 + 2.67*x1 + 3.07*x2 + 0.3*x3 <= 166)
m.addConstr(1.79*x2**2 + 1.35*x3**2 >= 20)
m.addConstr(0.99*x1**2 + 1.79*x2**2 + 1.35*x3**2 >= 40)
m.addConstr(0.53*x0 + 0.99*x1 + 1.35*x3 >= 40)
m.addConstr(0.99*x1**2 + 1.79*x2**2 + 1.35*x3**2 >= 40)
m.addConstr(0.53*x0**2 + 0.99*x1**2 + 1.35*x3**2 >= 40)
m.addConstr(2.94*x1 + 3.33*x3 >= 48)
m.addConstr(1.25*x0**2 + 3.33*x3**2 >= 50)
m.addConstr(1.25*x0 + 2.94*x1 >= 54)
m.addConstr(2.94*x1 + 0.12*x2 >= 41)
m.addConstr(0.12*x2 + 3.33*x3 >= 31)
m.addConstr(1.25*x0**2 + 0.12*x2**2 >= 20)
m.addConstr(1.25*x0**2 + 2.94*x1**2 + 3.33*x3**2 >= 33)
m.addConstr(2.67*x1 + 0.3*x3 >= 27)
m.addConstr(1.96*x0 + 3.07*x2 >= 41)
m.addConstr(2.67*x1 + 3.07*x2 >= 38)
m.addConstr(0.99*x1 + 1.79*x2 <= 205)
m.addConstr(0.99*x1 + 1.35*x3 <= 216)
m.addConstr(1.79*x2 + 1.35*x3 <= 64)
m.addConstr(0.53*x0**2 + 1.79*x2**2 + 1.35*x3**2 <= 62)
m.addConstr(0.99*x1 + 1.79*x2 + 1.35*x3 <= 116)
m.addConstr(0.53*x0 + 0.99*x1 + 1.35*x3 <= 188)
m.addConstr(0.53*x0 + 0.99*x1 + 1.79*x2 + 1.35*x3 <= 188)
m.addConstr(1.25*x0**2 + 0.12*x2**2 <= 149)
m.addConstr(2.94*x1 + 3.33*x3 <= 66)
m.addConstr(1.25*x0**2 + 3.33*x3**2 <= 66)
m.addConstr(0.12*x2 + 3.33*x3 <= 199)
m.addConstr(2.94*x1 + 0.12*x2 <= 183)
m.addConstr(1.25*x0 + 2.94*x1 <= 160)
m.addConstr(1.25*x0**2 + 2.94*x1**2 + 3.33*x3**2 <= 121)
m.addConstr(1.25*x0**2 + 0.12*x2**2 + 3.33*x3**2 <= 58)
m.addConstr(1.25*x0 + 2.94*x1 + 0.12*x2 + 3.33*x3 <= 58)
m.addConstr(2.67*x1 + 3.07*x2 <= 107)
m.addConstr(3.07*x2 + 0.3*x3 <= 88)
m.addConstr(1.96*x0 + 2.67*x1 <= 61)
m.addConstr(1.96*x0 + 2.67*x1 + 3.07*x2 + 0.3*x3 <= 61)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

