
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # hours worked by Bobby
    x1 = model.addVar(lb=0, vtype=GRB.INTEGER, name="x1") # hours worked by Hank


    # Set objective function
    model.setObjective(7.22*x0**2 + 4.56*x0*x1 + 9.3*x0 + 7.44*x1, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x0 + 14*x1 >= 21, "c0")
    model.addConstr(3*x0 + 4*x1 >= 20, "c1")
    model.addConstr(6*x0 - 6*x1 >= 0, "c2")
    model.addConstr(5*x0**2 + 14*x1**2 <= 114, "c3")
    model.addConstr(3*x0 + 4*x1 <= 49, "c4")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"x0 (hours worked by Bobby): {x0.x}")
        print(f"x1 (hours worked by Hank): {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
