
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")

# Set the objective function
m.setObjective(7.22*x1**2 + 4.56*x1*x2 + 9.3*x1 + 7.44*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 14*x2 >= 21, name="productivity_rating")
m.addConstr(3*x1 + 4*x2 >= 20, name="paperwork_competence_rating_lower")
m.addConstr(6*x1 - 6*x2 >= 0, name="hours_worked_difference")
m.addConstr((5*x1)**2 + (14*x2)**2 <= 114, name="productivity_squared")
m.addConstr(3*x1 + 4*x2 <= 49, name="paperwork_competence_rating_upper")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Bobby:", x1.x)
    print("Hours worked by Hank:", x2.x)
else:
    print("No optimal solution found.")

