
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Bobby", lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS)
x2 = m.addVar(name="hours_worked_by_Hank", lb=0, vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(7.22*x1**2 + 4.56*x1*x2 + 9.3*x1 + 7.44*x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x1 + 14*x2 >= 21, name="productivity_rating")
m.addConstr(3*x1 + 4*x2 >= 20, name="paperwork_competence_rating")
m.addConstr(6*x1 - 6*x2 >= 0, name="hours_worked_constraint")
m.addConstr(25*x1**2 + 196*x2**2 <= 114, name="productivity_rating_squared")
m.addConstr(3*x1 + 4*x2 <= 49, name="paperwork_competence_rating_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bobby: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
else:
    print("The model is infeasible")
