
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    model.setObjective(5*x0 + 8*x1 + 6*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(17*x1 + 2*x2 >= 19, "c0")
    model.addConstr(23*x0 + 17*x1 >= 26, "c1")
    model.addConstr(23*x0 + 17*x1 + 2*x2 >= 26, "c2")
    model.addConstr(28*x0 + 2*x1 >= 64, "c3")
    model.addConstr(28*x0 + 2*x2 >= 88, "c4")
    model.addConstr(28*x0 + 2*x1 + 2*x2 >= 88, "c5")
    model.addConstr(11*x0 + 8*x1 >= 82, "c6")
    model.addConstr(8*x1 + 10*x2 >= 104, "c7")
    model.addConstr(11*x0 + 10*x2 >= 87, "c8")
    model.addConstr(11*x0 + 8*x1 + 10*x2 >= 108, "c9")
    model.addConstr(27*x0 + 2*x1 >= 110, "c10")
    model.addConstr(2*x1 + 17*x2 >= 90, "c11")
    model.addConstr(27*x0 + 17*x2 >= 164, "c12")
    model.addConstr(27*x0 + 2*x1 + 17*x2 >= 164, "c13")
    model.addConstr(-3*x1 + x2 >= 0, "c14")
    model.addConstr(-2*x0 + 2*x2 >= 0, "c15")
    model.addConstr(23*x0 + 17*x1 <= 62, "c16")
    model.addConstr(23*x0 + 2*x2 <= 105, "c17")
    model.addConstr(2*x1 + 2*x2 <= 275, "c18")
    model.addConstr(8*x1 + 10*x2 <= 200, "c19")
    model.addConstr(11*x0 + 10*x2 <= 286, "c20")
    model.addConstr(2*x1 + 17*x2 <= 446, "c21")
    model.addConstr(27*x0 + 17*x2 <= 412, "c22")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Other model status')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
