
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Bobby
x1 = m.addVar(name="x1", lb=0)  # hours worked by Jean
x2 = m.addVar(name="x2", lb=0)  # hours worked by Ringo

# Define the objective function
m.setObjective(5 * x0 + 8 * x1 + 6 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(17 * x1 + 2 * x2 >= 19)
m.addConstr(23 * x0 + 17 * x1 >= 26)
m.addConstr(23 * x0 + 17 * x1 + 2 * x2 >= 26)
m.addConstr(28 * x0 + 2 * x1 >= 64)
m.addConstr(28 * x0 + 2 * x2 >= 88)
m.addConstr(28 * x0 + 2 * x1 + 2 * x2 >= 88)
m.addConstr(11 * x0 + 8 * x1 >= 82)
m.addConstr(8 * x1 + 10 * x2 >= 104)
m.addConstr(11 * x0 + 10 * x2 >= 87)
m.addConstr(11 * x0 + 8 * x1 + 10 * x2 >= 108)
m.addConstr(27 * x0 + 2 * x1 >= 110)
m.addConstr(2 * x1 + 17 * x2 >= 90)
m.addConstr(27 * x0 + 17 * x2 >= 164)
m.addConstr(27 * x0 + 2 * x1 + 17 * x2 >= 164)
m.addConstr(-3 * x1 + x2 >= 0)
m.addConstr(-2 * x0 + 2 * x2 >= 0)
m.addConstr(23 * x0 + 17 * x1 <= 62)
m.addConstr(23 * x0 + 2 * x2 <= 105)
m.addConstr(2 * x1 + 2 * x2 <= 275)
m.addConstr(8 * x1 + 10 * x2 <= 200)
m.addConstr(11 * x0 + 10 * x2 <= 286)
m.addConstr(2 * x1 + 17 * x2 <= 446)
m.addConstr(27 * x0 + 17 * x2 <= 412)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bobby: ", x0.varValue)
    print("Hours worked by Jean: ", x1.varValue)
    print("Hours worked by Ringo: ", x2.varValue)
else:
    print("The problem is infeasible")
