
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("flower_optimization")

    # Create variables
    petunias = m.addVar(vtype=gp.GRB.INTEGER, name="petunias")
    peonies = m.addVar(vtype=gp.GRB.INTEGER, name="peonies")
    verbenas = m.addVar(vtype=gp.GRB.INTEGER, name="verbenas")

    # Set objective function
    m.setObjective(8 * petunias + 7 * peonies + 7 * verbenas, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7 * petunias + 2 * peonies + 2 * verbenas <= 75, "resilience_total")
    m.addConstr(1 * petunias + 8 * peonies + 3 * verbenas <= 86, "yield_total")
    m.addConstr(5 * petunias + 3 * peonies + 4 * verbenas <= 79, "growth_speed_total")
    m.addConstr(2 * peonies + 2 * verbenas >= 8, "resilience_peonies_verbenas")
    m.addConstr(7 * petunias + 2 * verbenas >= 25, "resilience_petunias_verbenas")
    m.addConstr(5 * petunias + 3 * peonies >= 16, "growth_speed_petunias_peonies")
    m.addConstr(5 * petunias + 3 * peonies + 4 * verbenas >= 21, "growth_speed_all")
    m.addConstr(2 * peonies + 2 * verbenas <= 74, "resilience_peonies_verbenas_max")
    m.addConstr(7 * petunias + 2 * peonies <= 69, "resilience_petunias_peonies_max")
    m.addConstr(7 * petunias + 2 * verbenas <= 47, "resilience_petunias_verbenas_max")
    m.addConstr(7 * petunias + 2 * peonies + 2 * verbenas <= 47, "resilience_all_max")
    m.addConstr(1 * petunias + 3 * verbenas <= 45, "yield_petunias_verbenas_max")
    m.addConstr(1 * petunias + 8 * peonies <= 53, "yield_petunias_peonies_max")
    m.addConstr(1 * petunias + 8 * peonies + 3 * verbenas <= 53, "yield_all_max")
    m.addConstr(3 * peonies + 4 * verbenas <= 58, "growth_speed_peonies_verbenas_max")
    m.addConstr(5 * petunias + 3 * peonies + 4 * verbenas <= 58, "growth_speed_all_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('petunias:', petunias.x)
        print('peonies:', peonies.x)
        print('verbenas:', verbenas.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
