
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="petunias", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="peonies", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="verbenas", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(8*x0 + 7*x1 + 7*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(2*x1 + 2*x2 >= 8)
m.addConstr(7*x0 + 2*x1 + 2*x2 >= 25)
m.addConstr(5*x0 + 3*x1 >= 16)
m.addConstr(5*x0 + 3*x1 + 4*x2 >= 21)
m.addConstr(2*x1 + 2*x2 <= 74)
m.addConstr(7*x0 + 2*x1 <= 69)
m.addConstr(7*x0 + 2*x2 <= 47)
m.addConstr(7*x0 + 2*x1 + 2*x2 <= 47)
m.addConstr(x0 + 3*x2 <= 45)
m.addConstr(x0 + 8*x1 <= 53)
m.addConstr(x0 + 8*x1 + 3*x2 <= 53)
m.addConstr(3*x1 + 4*x2 <= 58)
m.addConstr(5*x0 + 3*x1 + 4*x2 <= 58)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Petunias: ", x0.varValue)
    print("Peonies: ", x1.varValue)
    print("Verbenas: ", x2.varValue)
else:
    print("The model is infeasible")
