
from gurobipy import Model, GRB

# Create a new model
model = Model("Nutrition_Optimization")

# Create variables
magnesium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="magnesium")
vitamin_b9 = model.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b9")
vitamin_b12 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b12")
vitamin_a = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_a")


# Set objective function
model.setObjective(1.53 * magnesium + 9.41 * vitamin_b9 + 1.22 * vitamin_b12 + 4.92 * vitamin_a, GRB.MINIMIZE)

# Add constraints
model.addConstr(17 * vitamin_b9 + 17 * vitamin_a >= 21, "c1")
model.addConstr(17 * magnesium + 21 * vitamin_b9 >= 16, "c2")
model.addConstr(21 * vitamin_b9 + 16 * vitamin_b12 >= 37, "c3")
model.addConstr(17 * magnesium + 21 * vitamin_b9 + 16 * vitamin_b12 + 17 * vitamin_a >= 37, "c4")
model.addConstr(23 * vitamin_b12 + 22 * vitamin_a >= 40, "c5")
model.addConstr(14 * magnesium + 23 * vitamin_b12 >= 43, "c6")
model.addConstr(25 * vitamin_b9 + 23 * vitamin_b12 + 22 * vitamin_a >= 34, "c7")
model.addConstr(14 * magnesium + 25 * vitamin_b9 + 23 * vitamin_b12 + 22 * vitamin_a >= 34, "c8")
model.addConstr(6 * vitamin_b9 - 10 * vitamin_a >= 0, "c9")
model.addConstr(16 * vitamin_b12 + 17 * vitamin_a <= 81, "c10")
model.addConstr(17 * magnesium + 16 * vitamin_b12 + 17 * vitamin_a <= 138, "c11")
model.addConstr(17 * magnesium + 21 * vitamin_b9 + 17 * vitamin_a <= 116, "c12")
model.addConstr(21 * vitamin_b9 + 16 * vitamin_b12 + 17 * vitamin_a <= 47, "c13")
model.addConstr(17 * magnesium + 21 * vitamin_b9 + 16 * vitamin_b12 <= 123, "c14")
model.addConstr(14 * magnesium + 25 * vitamin_b9 + 22 * vitamin_a <= 163, "c15")
model.addConstr(14 * magnesium + 25 * vitamin_b9 + 23 * vitamin_b12 <= 193, "c16")
model.addConstr(25 * vitamin_b9 + 23 * vitamin_b12 + 22 * vitamin_a <= 177, "c17")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('\nObjective Value:', model.objVal)
    print('\nSolution:')
    for v in model.getVars():
        print(f'{v.varName}: {v.x}')
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

