
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")  # milligrams of magnesium
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x1")  # milligrams of vitamin B9
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x2")  # milligrams of vitamin B12
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin A

    # Objective function
    model.setObjective(1.53*x0 + 9.41*x1 + 1.22*x2 + 4.92*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(17*x0 <= 156, name="cardiovascular_support_index_magnesium")
    model.addConstr(14*x0 <= 218, name="muscle_growth_index_magnesium")

    model.addConstr(21*x1 <= 156, name="cardiovascular_support_index_vitamin_B9")
    model.addConstr(25*x1 <= 218, name="muscle_growth_index_vitamin_B9")

    model.addConstr(16*x2 <= 156, name="cardiovascular_support_index_vitamin_B12")
    model.addConstr(23*x2 <= 218, name="muscle_growth_index_vitamin_B12")

    model.addConstr(17*x3 <= 156, name="cardiovascular_support_index_vitamin_A")
    model.addConstr(22*x3 <= 218, name="muscle_growth_index_vitamin_A")

    model.addConstr(21*x1 + 17*x3 >= 21, name="combined_cardiovascular_support_index_vitamin_B9_A")
    model.addConstr(17*x0 + 21*x1 >= 16, name="combined_cardiovascular_support_index_magnesium_vitamin_B9")
    model.addConstr(21*x1 + 16*x2 >= 37, name="combined_cardiovascular_support_index_vitamin_B9_B12")
    model.addConstr(17*x0 + 21*x1 + 16*x2 + 17*x3 >= 37, name="combined_cardiovascular_support_index_all")
    model.addConstr(23*x2 + 22*x3 >= 40, name="combined_muscle_growth_index_vitamin_B12_A")
    model.addConstr(14*x0 + 23*x2 >= 43, name="combined_muscle_growth_index_magnesium_B12")
    model.addConstr(25*x1 + 23*x2 + 22*x3 >= 34, name="combined_muscle_growth_index_vitamin_B9_B12_A")
    model.addConstr(14*x0 + 25*x1 + 23*x2 + 22*x3 >= 34, name="combined_muscle_growth_index_all")

    model.addConstr(6*x1 - 10*x3 >= 0, name="vitamin_B9_A_constraint")
    model.addConstr(16*x2 + 17*x3 <= 81, name="combined_cardiovascular_support_index_vitamin_B12_A_max")
    model.addConstr(17*x0 + 16*x2 + 17*x3 <= 138, name="combined_cardiovascular_support_index_magnesium_B12_A_max")
    model.addConstr(17*x0 + 21*x1 + 17*x3 <= 116, name="combined_cardiovascular_support_index_magnesium_B9_A_max")
    model.addConstr(21*x1 + 16*x2 + 17*x3 <= 47, name="combined_cardiovascular_support_index_vitamin_B9_B12_A_max")
    model.addConstr(17*x0 + 21*x1 + 16*x2 <= 123, name="combined_cardiovascular_support_index_magnesium_B9_B12_max")
    model.addConstr(14*x0 + 25*x1 + 17*x3 <= 163, name="combined_muscle_growth_index_magnesium_B9_A_max")
    model.addConstr(14*x0 + 25*x1 + 23*x2 <= 193, name="combined_muscle_growth_index_magnesium_B9_B12_max")
    model.addConstr(25*x1 + 23*x2 + 22*x3 <= 177, name="combined_muscle_growth_index_vitamin_B9_B12_A_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("milligrams of magnesium:", x0.varValue)
        print("milligrams of vitamin B9:", x1.varValue)
        print("milligrams of vitamin B12:", x2.varValue)
        print("milligrams of vitamin A:", x3.varValue)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
