
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("MilitaryOptimization")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="artillery_batteries")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="armored_companies")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="signal_platoons")


    # Set objective function
    model.setObjective(7.17 * x0 + 2.28 * x1 + 2.97 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * x0 + 9 * x1 + 13 * x2 >= 33, "c1")
    model.addConstr(2 * x0 + 9 * x1 >= 53, "c2")
    model.addConstr(2 * x0 + 9 * x1 + 13 * x2 >= 49, "c3")
    model.addConstr(7 * x0 + 5 * x1 >= 43, "c4")
    model.addConstr(7 * x0 + 5 * x1 + 6 * x2 >= 52, "c5")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print solution
        print("Optimal Solution:")
        print(f"Artillery Batteries: {x0.x}")
        print(f"Armored Companies: {x1.x}")
        print(f"Signal Platoons: {x2.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
