
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="artillery_batteries")
x1 = m.addVar(vtype=GRB.INTEGER, name="armored_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")

# Set objective function
m.setObjective(7.17*x0 + 2.28*x1 + 2.97*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 + 9*x1 + 13*x2 >= 49, name="total_weight_constraint")
m.addConstr(9*x1 + 13*x2 >= 33, name="armored_signal_weight_constraint")
m.addConstr(2*x0 + 9*x1 >= 53, name="artillery_armored_weight_constraint")
m.addConstr(7*x0 + 5*x1 + 6*x2 >= 52, name="total_offensive_capability_constraint")
m.addConstr(7*x0 + 5*x1 >= 43, name="artillery_armored_offensive_constraint")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
