
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="artillery_batteries", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="armored_companies", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="signal_platoons", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7.17 * x0 + 2.28 * x1 + 2.97 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * x0 + 9 * x1 + 13 * x2 >= 49, name="total_deployment_weight")
m.addConstr(9 * x1 + 13 * x2 >= 33, name="armored_signal_deployment")
m.addConstr(2 * x0 + 9 * x1 >= 53, name="artillery_armored_deployment")
m.addConstr(7 * x0 + 5 * x1 >= 43, name="artillery_armored_capability")
m.addConstr(7 * x0 + 5 * x1 + 6 * x2 >= 52, name="total_capability")

# Add bounds for resources if necessary
# Not directly needed as we have constraints

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Artillery Batteries: ", x0.varValue)
    print("Armored Companies: ", x1.varValue)
    print("Signal Platoons: ", x2.varValue)
else:
    print("The model is infeasible")
