
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
chicken_drumsticks = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_drumsticks")
hamburgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hamburgers")

# Set objective function
m.setObjective(4 * chicken_drumsticks + 3 * hamburgers, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * chicken_drumsticks + 3 * hamburgers >= 24, "carbohydrates_min")
m.addConstr(3 * chicken_drumsticks + 5 * hamburgers >= 13, "tastiness_min")
m.addConstr(14 * chicken_drumsticks + 6 * hamburgers >= 16, "protein_min")
m.addConstr(11 * chicken_drumsticks + 1 * hamburgers >= 18, "calcium_min")
m.addConstr(-6 * chicken_drumsticks + 3 * hamburgers >= 0, "custom_constraint")

m.addConstr(9 * chicken_drumsticks + 3 * hamburgers <= 33, "carbohydrates_max")
m.addConstr(3 * chicken_drumsticks + 5 * hamburgers <= 37, "tastiness_max")
m.addConstr(14 * chicken_drumsticks + 6 * hamburgers <= 36, "protein_max")
m.addConstr(11 * chicken_drumsticks + 1 * hamburgers <= 33, "calcium_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chicken_drumsticks:', chicken_drumsticks.x)
    print('hamburgers:', hamburgers.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

