
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="chicken_drumsticks", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="hamburgers")

# Set the objective function
model.setObjective(4 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(9 * x1 + 3 * x2 >= 24, name="carbohydrates_min")
model.addConstr(3 * x1 + 5 * x2 >= 13, name="tastiness_rating_min")
model.addConstr(14 * x1 + 6 * x2 >= 16, name="protein_min")
model.addConstr(11 * x1 + x2 >= 18, name="calcium_min")
model.addConstr(-6 * x1 + 3 * x2 >= 0, name="linear_combination")
model.addConstr(9 * x1 + 3 * x2 <= 33, name="carbohydrates_max")
model.addConstr(3 * x1 + 5 * x2 <= 37, name="tastiness_rating_max")
model.addConstr(14 * x1 + 6 * x2 <= 36, name="protein_max")
model.addConstr(11 * x1 + x2 <= 33, name="calcium_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Chicken drumsticks: ", x1.varValue)
    print("Hamburgers: ", x2.varValue)
else:
    print("The model is infeasible")
