
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(name="x0")  # milligrams of vitamin D
    x1 = m.addVar(name="x1")  # milligrams of calcium
    x2 = m.addVar(name="x2")  # milligrams of vitamin B7


    # Set objective function
    m.setObjective(3*x0**2 + 6*x0*x1 + 8*x1**2 + 8*x0 + 3*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5*x0 + 20*x1 + 19*x2 <= 101, "c0")
    m.addConstr(15*x0 + 3*x1 + 9*x2 <= 97, "c1")
    m.addConstr(4*x0 + 8*x1 + 7*x2 <= 320, "c2")
    m.addConstr(4*x0**2 + 8*x1**2 + 7*x2**2 >= 84, "c3")
    m.addConstr(20*x1 + 19*x2 <= 62, "c4")
    m.addConstr(5*x0 + 19*x2 <= 48, "c5")
    m.addConstr(5*x0 + 20*x1 + 19*x2 <= 48, "c6")
    m.addConstr(15*x0 + 9*x2 <= 76, "c7")
    m.addConstr(15*x0**2 + 3*x1**2 <= 42, "c8")
    m.addConstr(15*x0 + 3*x1 + 9*x2 <= 42, "c9")
    m.addConstr(8*x1**2 + 7*x2**2 <= 131, "c10")
    m.addConstr(4*x0**2 + 7*x2**2 <= 175, "c11")
    m.addConstr(4*x0 + 8*x1 + 7*x2 <= 124, "c12")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
