
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    napkins = m.addVar(vtype=gp.GRB.INTEGER, name="napkins")
    diapers = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
    candles = m.addVar(vtype=gp.GRB.INTEGER, name="candles")


    # Set objective function
    m.setObjective(2*napkins + 6*diapers + 7*candles, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(12*napkins + 11*diapers >= 11, "c0")
    m.addConstr(12*napkins + 11*diapers + 11*candles >= 34, "c1")
    m.addConstr(9*diapers + 5*candles >= 42, "c2")
    m.addConstr(6*napkins + 9*diapers >= 43, "c3")
    m.addConstr(6*napkins + 9*diapers + 5*candles >= 27, "c4")
    m.addConstr(14*napkins + 3*diapers >= 26, "c5")
    m.addConstr(14*napkins + 3*diapers + 1*candles >= 26, "c6")
    m.addConstr(6*diapers + 9*candles >= 45, "c7")
    m.addConstr(14*napkins + 6*diapers >= 22, "c8")
    m.addConstr(14*napkins + 6*diapers + 9*candles >= 33, "c9")
    m.addConstr(-napkins + 7*candles >= 0, "c10")
    m.addConstr(6*napkins - 2*diapers >= 0, "c11")
    m.addConstr(6*napkins + 9*diapers + 5*candles <= 117, "c12")

    # Resource Constraints
    m.addConstr(12*napkins + 11*diapers + 11*candles <= 105, "weight")
    m.addConstr(6*napkins + 9*diapers + 5*candles <= 131, "cost")
    m.addConstr(14*napkins + 3*diapers + 1*candles <= 157, "usefulness")
    m.addConstr(14*napkins + 6*diapers + 9*candles <= 162, "sustainability")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
