
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # packs of napkins
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # diapers
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # candles

    # Define the objective function
    model.setObjective(2 * x1 + 6 * x2 + 7 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12 * x1 + 11 * x2 >= 11)
    model.addConstr(12 * x1 + 11 * x2 + 11 * x3 >= 34)
    model.addConstr(9 * x2 + 5 * x3 >= 42)
    model.addConstr(6 * x1 + 9 * x2 >= 43)
    model.addConstr(6 * x1 + 9 * x2 + 5 * x3 >= 27)
    model.addConstr(14 * x1 + 3 * x2 >= 26)
    model.addConstr(14 * x1 + 3 * x2 + x3 >= 26)
    model.addConstr(6 * x2 + 9 * x3 >= 45)
    model.addConstr(14 * x1 + 6 * x2 >= 22)
    model.addConstr(14 * x1 + 6 * x2 + 9 * x3 >= 33)
    model.addConstr(-x1 + 7 * x3 >= 0)
    model.addConstr(6 * x1 - 2 * x2 >= 0)
    model.addConstr(6 * x1 + 9 * x2 + 5 * x3 <= 117)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
